<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%profile}}`.
 */
class m251112_121325_create_profile_table extends Migration
{
    public function safeUp()
    {
        $this->createTable('{{%profile}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'photo' => $this->string(255),
            'birth_date' => $this->date(),
            'gender' => $this->string(20),
            'citizenship' => $this->string(100),
            'passport_series' => $this->string(10),
            'passport_number' => $this->string(20),
            'passport_issued_by' => $this->string(255),
            'passport_issue_date' => $this->date(),
            'registration_address' => $this->string(255),
            'marital_status' => $this->string(100),
            'education_level' => $this->string(100),
            'education_institution' => $this->string(255),
            'specialty' => $this->string(255),
            'diploma_series' => $this->string(50),
            'diploma_number' => $this->string(50),
            'diploma_file' => $this->string(255),
            'snils' => $this->string(20),
            'snils_file' => $this->string(255),
            'workplace' => $this->string(255),
            'position' => $this->string(255),
            'work_experience' => $this->integer(),
            'health_status' => $this->string(255),
            'email' => $this->string(100),
            'phone' => $this->string(20),
            'additional_info' => $this->text(),
            'status' => $this->string(50)->defaultValue('Новая'),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ]);

        $this->addForeignKey(
            'fk-profile-user_id',
            '{{%profile}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE'
        );
    }

    public function safeDown()
    {
        $this->dropForeignKey('fk-profile-user_id', '{{%profile}}');
        $this->dropTable('{{%profile}}');
    }
}