<?php
use yii\grid\GridView;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Панель администратора';
?>
    <div class="admin-container">
        <div class="card mb-4">
            <div class="card-body">
                <h5 class="card-title mb-3">Фильтры и поиск</h5>
                <?php $form = ActiveForm::begin([
                    'method' => 'get',
                    'action' => ['admin/index'],
                    'options' => ['class' => 'filters-form']
                ]); ?>

                <div class="row g-3">
                    <div class="col-md-2">
                        <?= $form->field(new \yii\base\DynamicModel(['gender'=>$filters['gender'] ?? null]), 'gender')
                            ->dropDownList([
                                ''=>'Все',
                                'Мужской'=>'Мужской',
                                'Женский'=>'Женский'
                            ], ['class' => 'form-control form-control-sm'])->label('Пол') ?>
                    </div>
                    <div class="col-md-2">
                        <?= $form->field(new \yii\base\DynamicModel(['education_level'=>$filters['education_level'] ?? null]), 'education_level')
                            ->textInput(['class' => 'form-control form-control-sm', 'placeholder' => 'Образование'])->label('Образование') ?>
                    </div>
                    <div class="col-md-2">
                        <?= $form->field(new \yii\base\DynamicModel(['position'=>$filters['position'] ?? null]), 'position')
                            ->textInput(['class' => 'form-control form-control-sm', 'placeholder' => 'Должность'])->label('Должность') ?>
                    </div>
                    <div class="col-md-2">
                        <?= $form->field(new \yii\base\DynamicModel(['minExp'=>$filters['minExp'] ?? null]), 'minExp')
                            ->input('number', ['class' => 'form-control form-control-sm', 'placeholder' => 'Мин. стаж'])->label('Стаж от') ?>
                    </div>
                    <div class="col-md-2">
                        <?= $form->field(new \yii\base\DynamicModel(['maxExp'=>$filters['maxExp'] ?? null]), 'maxExp')
                            ->input('number', ['class' => 'form-control form-control-sm', 'placeholder' => 'Макс. стаж'])->label('Стаж до') ?>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <div class="d-flex gap-2 w-100">
                            <?= Html::submitButton('Фильтровать', ['class'=>'btn btn-primary btn-sm flex-fill']) ?>
                            <?= Html::a('Сбросить', ['admin/index'], ['class'=>'btn btn-outline-secondary btn-sm flex-fill']) ?>
                        </div>
                    </div>
                </div>
                <?php ActiveForm::end(); ?>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <?= GridView::widget([
                    'dataProvider' => $dataProvider,
                    'tableOptions' => ['class' => 'table table-hover table-sm'],
                    'options' => ['class' => 'grid-view'],
                    'columns' => [
                        [
                            'class' => 'yii\grid\SerialColumn',
                            'header' => '#',
                            'headerOptions' => ['style' => 'width: 50px'],
                            'contentOptions' => ['class' => 'text-muted']
                        ],
                        [
                            'attribute' => 'user_id',
                            'label' => 'ФИО',
                            'value' => function($m){ return $m->user->fio ?? '-'; },
                            'headerOptions' => ['style' => 'width: 200px']
                        ],
                        [
                            'attribute' => 'position',
                            'headerOptions' => ['style' => 'width: 150px']
                        ],
                        [
                            'attribute' => 'additional_info',
                            'value' => function($m){
                                return strlen($m->additional_info) > 50 ?
                                    substr($m->additional_info, 0, 50) . '...' :
                                    $m->additional_info;
                            },
                            'headerOptions' => ['style' => 'width: 250px']
                        ],
                        [
                            'attribute' => 'status',
                            'headerOptions' => ['style' => 'width: 150px'],
                            'contentOptions' => function($model) {
                                $class = 'badge bg-secondary';
                                if ($model->status == 'Идет проверка данных') $class = 'badge bg-warning';
                                if ($model->status == 'Данные приняты') $class = 'badge bg-success';
                                return ['class' => $class];
                            }
                        ],
                        [
                            'attribute' => 'created_at',
                            'format' => 'datetime',
                            'headerOptions' => ['style' => 'width: 150px'],
                            'contentOptions' => ['class' => 'text-muted']
                        ],
                        [
                            'class' => 'yii\grid\ActionColumn',
                            'template' => '{view} {status}',
                            'header' => 'Действия',
                            'headerOptions' => ['style' => 'width: 150px'],
                            'contentOptions' => ['class' => 'text-nowrap'],
                            'buttons' => [
                                'view' => function($url, $model, $key) {
                                    return Html::a('<i class="fas fa-eye"></i>', $url, [
                                        'class' => 'btn btn-outline-primary btn-sm',
                                        'title' => 'Просмотр'
                                    ]);
                                },
                                'status' => function($url, $model, $key) {
                                    return Html::dropDownList("status_{$model->id}", $model->status, [
                                        'Новая' => 'Новая',
                                        'Идет проверка данных' => 'Идет проверка данных',
                                        'Данные приняты' => 'Данные приняты'
                                    ], [
                                        'class' => 'form-select form-select-sm',
                                        'data-id' => $model->id,
                                        'title' => 'Изменить статус'
                                    ]);
                                }
                            ]
                        ],
                    ],
                    'pager' => [
                        'options' => ['class' => 'pagination justify-content-center mt-3'],
                        'linkContainerOptions' => ['class' => 'page-item'],
                        'linkOptions' => ['class' => 'page-link'],
                        'disabledListItemSubTagOptions' => ['class' => 'page-link']
                    ]
                ]); ?>
            </div>
        </div>
    </div>

<?php
$changeUrl = Url::to(['admin/change-status']);
$js = <<<JS
$(document).on('change', '.form-select', function(){
    var id = $(this).data('id');
    var status = $(this).val();
    var select = $(this);
    
    select.prop('disabled', true);
    
    $.post('$changeUrl', {id: id, status: status}, function(res){
        if(res.success){
            // Обновляем бейдж статуса
            var statusCell = select.closest('td').prev().prev();
            statusCell.find('.badge').removeClass('bg-secondary bg-warning bg-success');
            
            if(status == 'Новая') statusCell.find('.badge').addClass('bg-secondary');
            if(status == 'Идет проверка данных') statusCell.find('.badge').addClass('bg-warning');
            if(status == 'Данные приняты') statusCell.find('.badge').addClass('bg-success');
            
            statusCell.find('.badge').text(status);
        } else {
            alert('Ошибка: ' + res.message);
        }
        select.prop('disabled', false);
    }, 'json').fail(function(){
        alert('Ошибка сети');
        select.prop('disabled', false);
    });
});
JS;
$this->registerJs($js);
?>