<?php
use yii\helpers\Html;
$this->title = 'Личный кабинет';
?>

<h1><?= Html::encode($this->title) ?></h1>

<div class="card">
    <div class="card-body">
        <h3><?= Html::encode($model->fio ?? $model->user->fio) ?></h3>
        <p><strong>Статус анкеты:</strong> <?= Html::encode($model->status) ?></p>
        <p><strong>Дата рождения:</strong> <?= Html::encode($model->birth_date) ?></p>
        <p><strong>Телефон:</strong> <?= Html::encode($model->phone ?? $model->user->phone) ?></p>
        <p><strong>Email:</strong> <?= Html::encode($model->email ?? $model->user->email) ?></p>
        <p><strong>Гражданство:</strong> <?= Html::encode($model->citizenship) ?></p>
        <p><strong>Должность:</strong> <?= Html::encode($model->position) ?>, <strong>Стаж:</strong> <?= Html::encode($model->work_experience) ?></p>

        <?php if (!empty($model->photo)): ?>
            <p><strong>Фото:</strong><br>
                <?= Html::img('/' . $model->photo, ['style'=>'max-width:200px;max-height:200px']) ?>
            </p>
        <?php endif; ?>

        <?php if (!empty($model->passport_file)): ?>
            <p><strong>Скан паспорта:</strong> <?= Html::a('Скачать', '/' . $model->passport_file, ['target'=>'_blank']) ?></p>
        <?php endif; ?>

        <?php if (!empty($model->diploma_file)): ?>
            <p><strong>Скан диплома:</strong> <?= Html::a('Скачать', '/' . $model->diploma_file, ['target'=>'_blank']) ?></p>
        <?php endif; ?>

        <?php if (!empty($model->snils_file)): ?>
            <p><strong>Скан СНИЛС:</strong> <?= Html::a('Скачать', '/' . $model->snils_file, ['target'=>'_blank']) ?></p>
        <?php endif; ?>

        <p>
            <?= Html::a('Редактировать анкету', ['profile/edit'], ['class'=>'btn btn-primary']) ?>
        </p>
    </div>
</div>
